<?php

class AdministrationModule extends CWebModule
{
	public $defaultController = 'main';
	private $_assetsUrl = null;

	public function getName()
	{
		return 'Panel administratora';
	}

	public function init()
	{
		$this->setImport(array(
			'administration.models.*',
			'administration.components.*',
		));

		Yii::app()->user->loginUrl = Yii::app()->createUrl('/administration/main/login');
		Yii::app()->errorHandler->errorAction = 'administration/main/error';
	}

	public function getAssetsUrl($returnWithBaseUrl = true)
	{
		if($this->_assetsUrl === null)
			$this->_assetsUrl = Yii::app()->assetManager->publish(Yii::getPathOfAlias('administration.assets'), false, -1, defined('YII_DEBUG') && YII_DEBUG);

		if($returnWithBaseUrl)
			return $this->_assetsUrl;
		else
		{
			if(substr($this->_assetsUrl, 0, strlen(Yii::app()->baseUrl)) == Yii::app()->baseUrl)
				return substr($this->_assetsUrl, strlen(Yii::app()->baseUrl) + 1);
			else
				return substr($this->_assetsUrl, 1);
		}
	}

	public function beforeControllerAction($controller, $action)
	{
		if(Yii::app()->user->isStudent)
			Yii::app()->user->logout();
		
		if(parent::beforeControllerAction($controller, $action))
		{
			return true;
		}

		return false;
	}
}
